/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class SwampEnderman
extends BaseEnderman {
    public SwampEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 8;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.216).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnSwampEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, state -> {
            state.getController().setAnimation((double)state.getLimbSwingAmount() > 0.01 || (double)state.getLimbSwingAmount() < -0.01 ? ConstantAnimations.WALK : ConstantAnimations.IDLE);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "creepy_controller", 5.0f, state -> {
            if (!this.canOpenMouth()) {
                return PlayState.STOP;
            }
            if (!this.m_32531_()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ANGRY);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "hold_controller", 5.0f, state -> {
            if (!this.canPickupBlocks()) {
                return PlayState.STOP;
            }
            if (this.m_32530_() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_controller", 5.0f, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean hasParticles() {
        return false;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public double getVisionRange() {
        return 32.0;
    }

    public boolean m_6126_() {
        return false;
    }

    @Override
    @Nullable
    public MobEffectInstance getHitEffect() {
        return new MobEffectInstance(new MobEffectInstance(MobEffects.f_19614_, 100, 2));
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.PLANT_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.PLANT_ENDERMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.PLANT_ENDERMAN_HURT.get();
    }
}

